/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Test;

public class AggregateCompletionOnNewCorrelationGroupTest
extends ContextTestSupport {
    @Test
    public void testCompletionOnNewCorrelationGroup() throws Exception {
        this.getMockEndpoint("mock:aggregated").expectedBodiesReceived(new Object[]{"AA", "BB", "CCC"});
        this.template.sendBodyAndHeader("direct:start", (Object)"A", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"A", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"B", "id", (Object)"2");
        this.template.sendBodyAndHeader("direct:start", (Object)"B", "id", (Object)"2");
        this.template.sendBodyAndHeader("direct:start", (Object)"C", "id", (Object)"3");
        this.template.sendBodyAndHeader("direct:start", (Object)"C", "id", (Object)"3");
        this.template.sendBodyAndHeader("direct:start", (Object)"C", "id", (Object)"3");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").aggregate((Expression)this.header("id"), (AggregationStrategy)new MyAggregationStrategy()).completionOnNewCorrelationGroup().completionSize(3).to(new String[]{"log:aggregated", "mock:aggregated"});
            }
        };
    }

    public static class MyAggregationStrategy
    implements AggregationStrategy {
        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            if (oldExchange == null) {
                return newExchange;
            }
            String body1 = (String)oldExchange.getIn().getBody(String.class);
            String body2 = (String)newExchange.getIn().getBody(String.class);
            oldExchange.getIn().setBody((Object)(body1 + body2));
            return oldExchange;
        }
    }
}

