/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import java.util.List;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.processor.aggregate.GroupedMessageAggregationStrategy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AggregateCompletionByBatchConsumerTest
extends ContextTestSupport {
    @Test
    public void testCorrelationKey() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(4);
        Integer batch_size = 8;
        this.template.sendBodyAndProperty("direct:start", (Object)"batch-4", "CamelBatchSize", (Object)batch_size);
        this.template.sendBodyAndProperty("direct:start", (Object)"batch-4", "CamelBatchSize", (Object)batch_size);
        this.template.sendBodyAndProperty("direct:start", (Object)"batch-3", "CamelBatchSize", (Object)batch_size);
        this.template.sendBodyAndProperty("direct:start", (Object)"batch-3", "CamelBatchSize", (Object)batch_size);
        this.template.sendBodyAndProperty("direct:start", (Object)"batch-2", "CamelBatchSize", (Object)batch_size);
        this.template.sendBodyAndProperty("direct:start", (Object)"batch-2", "CamelBatchSize", (Object)batch_size);
        this.template.sendBodyAndProperty("direct:start", (Object)"batch-1", "CamelBatchSize", (Object)batch_size);
        this.template.sendBodyAndProperty("direct:start", (Object)"batch-1", "CamelBatchSize", (Object)batch_size);
        this.assertMockEndpointsSatisfied();
        Exchange out = (Exchange)result.getExchanges().get(1);
        List grouped = (List)out.getIn().getBody(List.class);
        Assertions.assertEquals((int)2, (int)grouped.size());
        Assertions.assertEquals((Object)"batch-2", (Object)((Message)grouped.get(0)).getBody(String.class));
        Assertions.assertEquals((Object)"batch-2", (Object)((Message)grouped.get(1)).getBody(String.class));
        Assertions.assertEquals((Object)"batch-2", (Object)out.getProperty("CamelAggregatedCorrelationKey"));
        out = (Exchange)result.getExchanges().get(2);
        grouped = (List)out.getIn().getBody(List.class);
        Assertions.assertEquals((int)2, (int)grouped.size());
        Assertions.assertEquals((Object)"batch-3", (Object)((Message)grouped.get(0)).getBody(String.class));
        Assertions.assertEquals((Object)"batch-3", (Object)((Message)grouped.get(1)).getBody(String.class));
        Assertions.assertEquals((Object)"batch-3", (Object)out.getProperty("CamelAggregatedCorrelationKey"));
        out = (Exchange)result.getExchanges().get(3);
        grouped = (List)out.getIn().getBody(List.class);
        Assertions.assertEquals((int)2, (int)grouped.size());
        Assertions.assertEquals((Object)"batch-4", (Object)((Message)grouped.get(0)).getBody(String.class));
        Assertions.assertEquals((Object)"batch-4", (Object)((Message)grouped.get(1)).getBody(String.class));
        Assertions.assertEquals((Object)"batch-4", (Object)out.getProperty("CamelAggregatedCorrelationKey"));
        out = (Exchange)result.getExchanges().get(0);
        grouped = (List)out.getIn().getBody(List.class);
        Assertions.assertEquals((int)2, (int)grouped.size());
        Assertions.assertEquals((Object)"batch-1", (Object)((Message)grouped.get(0)).getBody(String.class));
        Assertions.assertEquals((Object)"batch-1", (Object)((Message)grouped.get(1)).getBody(String.class));
        Assertions.assertEquals((Object)"batch-1", (Object)out.getProperty("CamelAggregatedCorrelationKey"));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").aggregate((Expression)this.body(), (AggregationStrategy)new GroupedMessageAggregationStrategy()).completionFromBatchConsumer().eagerCheckCompletion().to("mock:result");
            }
        };
    }
}

