/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.BodyInAggregatingStrategy;
import org.apache.camel.processor.aggregate.MemoryAggregationRepository;
import org.apache.camel.spi.AggregationRepository;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;

@DisabledOnOs(architectures={"s390x"}, disabledReason="This test does not run reliably on s390x (see CAMEL-21438)")
public class AggregateCompleteAllOnStopTest
extends ContextTestSupport {
    @Test
    public void testCompleteAllOnStop() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:aggregated");
        mock.expectedBodiesReceived(new Object[]{"A+B", "C"});
        MockEndpoint input = this.getMockEndpoint("mock:input");
        input.expectedMessageCount(3);
        this.template.sendBodyAndHeader("seda:start", (Object)"A", "id", (Object)"foo");
        this.template.sendBodyAndHeader("seda:start", (Object)"B", "id", (Object)"foo");
        this.template.sendBodyAndHeader("seda:start", (Object)"C", "id", (Object)"foo");
        input.assertIsSatisfied();
        this.context.getRouteController().stopRoute("foo");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("seda:start").routeId("foo").to("mock:input")).aggregate((Expression)this.header("id"), (AggregationStrategy)new BodyInAggregatingStrategy()).aggregationRepository((AggregationRepository)new MemoryAggregationRepository()).completionSize(2).completionTimeout(100L).completeAllOnStop().completionTimeoutCheckerInterval(10L).to("mock:aggregated");
            }
        };
    }
}

