/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import java.util.function.BiFunction;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Test;

public class AggregateBiFunctionTest
extends ContextTestSupport {
    private final BiFunction<Exchange, Exchange, Object> myAgg = (e1, e2) -> (String)e1.getMessage().getBody(String.class) + "+" + (String)e2.getMessage().getBody(String.class);

    @Test
    public void testBiFunction() throws Exception {
        this.getMockEndpoint("mock:aggregated").expectedBodiesReceived(new Object[]{"A+B+C"});
        this.template.sendBodyAndHeader("direct:start", (Object)"A", "id", (Object)123);
        this.template.sendBodyAndHeader("direct:start", (Object)"B", "id", (Object)123);
        this.template.sendBodyAndHeader("direct:start", (Object)"C", "id", (Object)123);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                AggregateBiFunctionTest.this.context.getRegistry().bind("myAgg", AggregateBiFunctionTest.this.myAgg);
                this.from("direct:start").aggregate((Expression)this.header("id")).aggregationStrategy("myAgg").completionSize(3).to("mock:aggregated");
            }
        };
    }
}

