/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Test;

public class AggregateAggregationStrategyIsPredicateTest
extends ContextTestSupport {
    @Test
    public void testAggregateCompletionAware() throws Exception {
        this.getMockEndpoint("mock:aggregated").expectedBodiesReceived(new Object[]{"A+B+C", "X+Y+ZZZZ"});
        this.template.sendBodyAndHeader("direct:start", (Object)"A", "id", (Object)123);
        this.template.sendBodyAndHeader("direct:start", (Object)"B", "id", (Object)123);
        this.template.sendBodyAndHeader("direct:start", (Object)"C", "id", (Object)123);
        this.template.sendBodyAndHeader("direct:start", (Object)"X", "id", (Object)123);
        this.template.sendBodyAndHeader("direct:start", (Object)"Y", "id", (Object)123);
        this.template.sendBodyAndHeader("direct:start", (Object)"ZZZZ", "id", (Object)123);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").aggregate((Expression)this.header("id"), (AggregationStrategy)new MyCompletionStrategy()).to("mock:aggregated");
            }
        };
    }

    private static final class MyCompletionStrategy
    implements AggregationStrategy,
    Predicate {
        private MyCompletionStrategy() {
        }

        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            if (oldExchange == null) {
                return newExchange;
            }
            String oldBody = (String)oldExchange.getIn().getBody(String.class);
            String newBody = (String)newExchange.getIn().getBody(String.class);
            oldExchange.getIn().setBody((Object)(oldBody + "+" + newBody));
            return oldExchange;
        }

        public boolean matches(Exchange exchange) {
            return ((String)exchange.getIn().getBody(String.class)).length() >= 5;
        }
    }
}

