/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.FilterDefinition;
import org.apache.camel.support.builder.Namespaces;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class XPathWithNamespacesFilterTest
extends ContextTestSupport {
    protected Endpoint startEndpoint;
    protected MockEndpoint resultEndpoint;

    @Test
    public void testSendMatchingMessage() throws Exception {
        this.resultEndpoint.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"<person xmlns='http://acme.com/cheese' name='James' city='London'/>");
        this.resultEndpoint.assertIsSatisfied();
    }

    @Test
    public void testSendNotMatchingMessage() throws Exception {
        this.resultEndpoint.expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"<person xmlns='http://acme.com/cheese'  name='Hiram' city='Tampa'/>");
        this.resultEndpoint.assertIsSatisfied();
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.startEndpoint = this.resolveMandatoryEndpoint("direct:start");
        this.resultEndpoint = this.getMockEndpoint("mock:result");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                Namespaces ns = new Namespaces("c", "http://acme.com/cheese");
                ((FilterDefinition)this.from("direct:start").filter().xpath("/c:person[@name='James']", ns)).to("mock:result");
            }
        };
    }
}

