/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class XPathResultTypeTest
extends ContextTestSupport {
    @Test
    public void xpathLongAndObject() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"iso-8859-1\"?>\n<Books count=\"2\">\n  <Book Id=\"1\" ISBN=\"1\"><Titel>First</Titel></Book>\n  <Book Id=\"2\" ISBN=\"2\"><Titel>SECOND</Titel></Book>\n</Books>";
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        ((MockValueBuilder)this.getMockEndpoint("mock:result").message(0).exchangeProperty("BOOK_COUNT")).isEqualTo((Object)2);
        this.getMockEndpoint("mock:split").expectedMessageCount(2);
        ((MockValueBuilder)this.getMockEndpoint("mock:split").message(0).body(String.class)).contains((Object)"First");
        ((MockValueBuilder)this.getMockEndpoint("mock:split").message(1).body(String.class)).contains((Object)"SECOND");
        this.template.sendBody("direct:start", (Object)xml);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ExpressionNode)((RouteDefinition)this.from("direct:start").setProperty("BOOK_COUNT", (Expression)this.xpath("//Books/@count", Long.class))).split((Expression)this.xpath("//Books/Book")).to("mock:split")).end().to("mock:result");
            }
        };
    }
}

