/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spi.Registry;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WireTapVoidBeanTest
extends ContextTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(WireTapVoidBeanTest.class);

    @Test
    public void testWireTapToVoidBean() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        MyTapBean tapBean = (MyTapBean)this.context.getRegistry().lookupByName("tap");
        Awaitility.await().atMost(2L, TimeUnit.SECONDS).untilAsserted(() -> Assertions.assertEquals((Object)"Hello World", (Object)tapBean.getTapped()));
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("tap", (Object)new MyTapBean());
        return jndi;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").wireTap("bean:tap").dynamicUri(false).to("mock:result");
            }
        };
    }

    public static class MyTapBean {
        private String tapped;

        public void tapSomething(String body) {
            LOG.info("Wire tapping: {}", (Object)body);
            this.tapped = body;
        }

        public String getTapped() {
            return this.tapped;
        }
    }
}

