/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class WireTapVariableTest
extends ContextTestSupport {
    @Test
    public void testSend() throws Exception {
        this.getMockEndpoint("mock:before").expectedBodiesReceived(new Object[]{"World"});
        this.getMockEndpoint("mock:before").expectedVariableReceived("hello", (Object)"Camel");
        this.getMockEndpoint("mock:tap").expectedBodiesReceived(new Object[]{"Bye Camel"});
        this.getMockEndpoint("mock:tap").expectedVariableReceived("hello", (Object)"Camel");
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"World"});
        this.getMockEndpoint("mock:result").expectedVariableReceived("hello", (Object)"Camel");
        this.template.sendBody("direct:send", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from("direct:send").setVariable("hello", (Expression)this.simple("Camel"))).to("mock:before")).wireTap("direct:foo", "hello").to("mock:result");
                ((ProcessorDefinition)this.from("direct:foo").transform().simple("Bye ${body}")).to("mock:tap");
            }
        };
    }
}

