/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class WireTapUsingMulticastTest
extends ContextTestSupport {
    protected MockEndpoint tap;
    protected MockEndpoint result;

    @Test
    public void testSend() throws Exception {
        String body = "<body/>";
        this.tap.expectedBodiesReceived(new Object[]{body});
        this.result.expectedBodiesReceived(new Object[]{body});
        MockEndpoint.expectsMessageCount((int)1, (MockEndpoint[])new MockEndpoint[]{this.tap, this.result});
        this.template.sendBody("direct:start", (Object)body);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.tap = this.getMockEndpoint("mock:tap");
        this.result = this.getMockEndpoint("mock:result");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").multicast().to(new String[]{"mock:tap", "mock:result"});
            }
        };
    }
}

