/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.Exchanger;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spi.Registry;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WireTapShutdownRouteTest
extends ContextTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(WireTapShutdownRouteTest.class);
    private static final Exchanger<Void> EXCHANGER = new Exchanger();

    @Test
    public void testWireTapShutdown() throws Exception {
        MyTapBean tapBean = (MyTapBean)this.context.getRegistry().lookupByName("tap");
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        EXCHANGER.exchange(null);
        this.context.stop();
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).untilAsserted(() -> Assertions.assertEquals((Object)"Hello World", (Object)tapBean.getTapped()));
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("tap", (Object)new MyTapBean());
        return jndi;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").routeId("foo").wireTap("direct:tap").to("mock:result");
                this.from("direct:tap").routeId("bar").to("bean:tap");
            }
        };
    }

    public static class MyTapBean {
        private String tapped;

        public void tapSomething(String body) {
            try {
                EXCHANGER.exchange(null);
                Thread.sleep(100L);
            }
            catch (Exception e) {
                Assertions.fail((String)"Should not be interrupted");
            }
            LOG.info("Wire tapping: {}", (Object)body);
            this.tapped = body;
        }

        public String getTapped() {
            return this.tapped;
        }
    }
}

