/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.Animal;
import org.apache.camel.processor.AnimalDeepClonePrepare;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class WireTapOnPrepareTest
extends ContextTestSupport {
    @Test
    public void testWireTapOnPrepare() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        ((MockValueBuilder)this.getMockEndpoint("mock:a").message(0).body(String.class)).isEqualTo((Object)"1 Tony the Tiger");
        this.getMockEndpoint("mock:b").expectedMessageCount(1);
        ((MockValueBuilder)this.getMockEndpoint("mock:b").message(0).body(String.class)).isEqualTo((Object)"1 Tiger");
        Animal original = new Animal(1, "Tiger");
        this.template.sendBody("direct:start", (Object)original);
        this.assertMockEndpointsSatisfied();
        Animal aAnimal = (Animal)((Exchange)this.getMockEndpoint("mock:a").getExchanges().get(0)).getIn().getBody(Animal.class);
        Animal bAnimal = (Animal)((Exchange)this.getMockEndpoint("mock:b").getExchanges().get(0)).getIn().getBody(Animal.class);
        Assertions.assertSame((Object)original, (Object)bAnimal, (String)"Original instance should stay in main route");
        Assertions.assertNotSame((Object)original, (Object)aAnimal, (String)"Copy should go to Wire Tap Endpoint");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").wireTap("direct:a").copy().onPrepare((Processor)new AnimalDeepClonePrepare()).to("direct:b");
                ((RouteDefinition)this.from("direct:a").process((Processor)new ProcessorA())).to("mock:a");
                ((ExpressionNode)this.from("direct:b").delay(1000L).process((Processor)new ProcessorB())).to("mock:b");
            }
        };
    }

    public static class ProcessorB
    implements Processor {
        public void process(Exchange exchange) {
            Animal body = (Animal)exchange.getIn().getBody(Animal.class);
            Assertions.assertEquals((int)1, (int)body.getId());
            Assertions.assertEquals((Object)"Tiger", (Object)body.getName());
        }
    }

    public static class ProcessorA
    implements Processor {
        public void process(Exchange exchange) {
            Animal body = (Animal)exchange.getIn().getBody(Animal.class);
            Assertions.assertEquals((int)1, (int)body.getId());
            Assertions.assertEquals((Object)"Tiger", (Object)body.getName());
            body.setName("Tony the Tiger");
        }
    }
}

