/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.junit.jupiter.api.Test;

public class WireTapOnExceptionTest
extends ContextTestSupport {
    @Test
    public void testWireTapOnException() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:error").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() throws Exception {
                MyProducerFailEndpoint my = new MyProducerFailEndpoint("myEndpoint://foo", this.getContext());
                WireTapOnExceptionTest.this.context.addEndpoint("myEndpoint://foo", (Endpoint)my);
                this.onException(IllegalArgumentException.class).to("mock:error");
                this.from("direct:start").wireTap("myEndpoint:foo").to("mock:result");
            }
        };
    }

    public static final class MyProducerFailEndpoint
    extends DefaultEndpoint {
        private MyProducerFailEndpoint(String endpointUri, CamelContext camelContext) {
            super(endpointUri, null);
            this.setCamelContext(camelContext);
        }

        public Producer createProducer() {
            return new DefaultProducer((Endpoint)this){

                public void process(Exchange exchange) {
                    throw new IllegalArgumentException("Forced");
                }
            };
        }

        public Consumer createConsumer(Processor processor) {
            return null;
        }

        public boolean isSingleton() {
            return true;
        }
    }
}

