/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class WireTapNoErrorHandlerTest
extends ContextTestSupport {
    @Test
    public void testWireTap() throws Exception {
        MockEndpoint tap = this.getMockEndpoint("mock:tap");
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedBodiesReceived(new Object[]{"Hello World", "Tapped"});
        tap.expectedBodiesReceived(new Object[]{"Tapped"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").errorHandler((ErrorHandlerFactory)this.noErrorHandler()).to("log:foo")).wireTap("direct:tap").to("mock:result");
                ((ProcessorDefinition)this.from("direct:tap").delay(1000L).setBody().constant((Object)"Tapped")).to(new String[]{"mock:result", "mock:tap"});
            }
        };
    }
}

