/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ToDynamicDefinition;
import org.apache.camel.processor.WireTapProcessor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class WireTapNoCacheTest
extends ContextTestSupport {
    @Test
    public void testNoCache() throws Exception {
        Assertions.assertEquals((int)1, (int)this.context.getEndpointRegistry().size());
        this.sendBody("foo", "mock:x");
        this.sendBody("foo", "mock:y");
        this.sendBody("foo", "mock:z");
        this.sendBody("bar", "mock:x");
        this.sendBody("bar", "mock:y");
        this.sendBody("bar", "mock:z");
        List<Processor> list = this.getProcessors("foo");
        WireTapProcessor wtp = (WireTapProcessor)list.get(0);
        Assertions.assertNotNull((Object)wtp);
        Assertions.assertEquals((int)-1, (int)wtp.getCacheSize());
        Assertions.assertEquals((int)1, (int)this.context.getEndpointRegistry().size());
        MockEndpoint x = this.getMockEndpoint("mock:x2");
        MockEndpoint y = this.getMockEndpoint("mock:y2");
        MockEndpoint z = this.getMockEndpoint("mock:z2");
        x.expectedBodiesReceivedInAnyOrder(new Object[]{"foo", "bar"});
        y.expectedBodiesReceivedInAnyOrder(new Object[]{"foo", "bar"});
        z.expectedBodiesReceivedInAnyOrder(new Object[]{"foo", "bar"});
        Assertions.assertEquals((int)4, (int)this.context.getEndpointRegistry().size());
        this.sendBody("foo", "mock:x2");
        this.sendBody("foo", "mock:y2");
        this.sendBody("foo", "mock:z2");
        this.sendBody("bar", "mock:x2");
        this.sendBody("bar", "mock:y2");
        this.sendBody("bar", "mock:z2");
        this.sendBody("dummy", "mock:dummy");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)4, (int)this.context.getEndpointRegistry().size());
    }

    protected void sendBody(String body, String uri) {
        this.template.sendBodyAndHeader("direct:a", (Object)body, "myHeader", (Object)uri);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ToDynamicDefinition)this.from("direct:a").wireTap("${header.myHeader}").cacheSize(-1).id("foo")).end();
            }
        };
    }
}

