/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.ToDynamicDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.MDC;

public class WireTapMDCTest
extends ContextTestSupport {
    @Test
    public void testMdcPreserved() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:end");
        mock.expectedMessageCount(2);
        this.template.sendBody("seda:a", (Object)"A");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                WireTapMDCTest.this.context.setUseMDCLogging(Boolean.valueOf(true));
                WireTapMDCTest.this.context.setUseBreadcrumb(Boolean.valueOf(true));
                WireTapMDCTest.this.context.setMDCLoggingKeysPattern("custom*,my*");
                MdcCheckerProcessor checker = new MdcCheckerProcessor("route-a", "World", "MyValue");
                MdcCheckerProcessor checker2 = new MdcCheckerProcessor("route-b", "Moon", "MyValue2");
                ((ToDynamicDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("seda:a").routeId("route-a").process(e -> {
                    MDC.put((String)"custom.hello", (String)"World");
                    MDC.put((String)"foo", (String)"Bar");
                    MDC.put((String)"myKey", (String)"MyValue");
                })).process((Processor)checker)).to("log:a")).wireTap("direct:b").process((Processor)checker)).to("mock:end");
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:b").routeId("route-b").process(e -> {
                    MDC.put((String)"custom.hello", (String)"Moon");
                    MDC.put((String)"foo", (String)"Bar2");
                    MDC.put((String)"myKey", (String)"MyValue2");
                })).process((Processor)checker2)).to("log:b")).to("mock:end");
            }
        };
    }

    private static class MdcCheckerProcessor
    implements Processor {
        private String exchangeId;
        private String messageId;
        private String breadcrumbId;
        private String contextId;
        private Long threadId;
        private String foo;
        private final String expected1;
        private final String expected2;
        private final String expected3;

        public MdcCheckerProcessor(String expected1, String expected2, String expected3) {
            this.expected1 = expected1;
            this.expected2 = expected2;
            this.expected3 = expected3;
        }

        public void process(Exchange exchange) {
            Assertions.assertEquals((Object)this.expected2, (Object)MDC.get((String)"custom.hello"));
            Assertions.assertEquals((Object)this.expected3, (Object)MDC.get((String)"myKey"));
            if (this.foo != null) {
                Assertions.assertEquals((Object)this.foo, (Object)MDC.get((String)"foo"));
            } else {
                this.foo = MDC.get((String)"foo");
            }
            if (this.threadId != null) {
                long currId = Thread.currentThread().getId();
                Assertions.assertEquals((Object)this.threadId, (Object)currId);
            } else {
                this.threadId = Thread.currentThread().getId();
            }
            if (this.expected1 != null) {
                Assertions.assertEquals((Object)this.expected1, (Object)MDC.get((String)"camel.routeId"));
            }
            if (this.exchangeId != null) {
                Assertions.assertEquals((Object)this.exchangeId, (Object)MDC.get((String)"camel.exchangeId"));
            } else {
                this.exchangeId = MDC.get((String)"camel.exchangeId");
                Assertions.assertTrue((this.exchangeId != null && !this.exchangeId.isEmpty() ? 1 : 0) != 0);
            }
            if (this.messageId != null) {
                Assertions.assertEquals((Object)this.messageId, (Object)MDC.get((String)"camel.messageId"));
            } else {
                this.messageId = MDC.get((String)"camel.messageId");
                Assertions.assertTrue((this.messageId != null && !this.messageId.isEmpty() ? 1 : 0) != 0);
            }
            if (this.breadcrumbId != null) {
                Assertions.assertEquals((Object)this.breadcrumbId, (Object)MDC.get((String)"camel.breadcrumbId"));
            } else {
                this.breadcrumbId = MDC.get((String)"camel.breadcrumbId");
                Assertions.assertTrue((this.breadcrumbId != null && !this.breadcrumbId.isEmpty() ? 1 : 0) != 0);
            }
            if (this.contextId != null) {
                Assertions.assertEquals((Object)this.contextId, (Object)MDC.get((String)"camel.contextId"));
            } else {
                this.contextId = MDC.get((String)"camel.contextId");
                Assertions.assertTrue((this.contextId != null && !this.contextId.isEmpty() ? 1 : 0) != 0);
            }
        }
    }
}

