/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.ToDynamicDefinition;
import org.apache.camel.spi.Registry;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;

@DisabledOnOs(architectures={"s390x"}, disabledReason="This test does not run reliably on s390x (see CAMEL-21438)")
public class WireTapBeanAsProcessorTest
extends ContextTestSupport {
    private final MyBean myBean = new MyBean();
    private MockEndpoint result;

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("tap", (Object)this.myBean);
        return jndi;
    }

    @Test
    public void testBeanAsProcessor() throws Exception {
        Assertions.assertNull((Object)this.myBean.getTapped());
        this.result.expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)"World");
        this.assertMockEndpointsSatisfied();
        Awaitility.await().atMost(2L, TimeUnit.SECONDS).untilAsserted(() -> Assertions.assertEquals((Object)"World", (Object)this.myBean.getTapped()));
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.result = this.getMockEndpoint("mock:result");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ToDynamicDefinition)((RouteDefinition)this.from("direct:start").to("log:foo")).wireTap("bean:tap").transform((Expression)this.body().prepend((Object)"Bye "))).to("mock:result");
            }
        };
    }

    public static class MyBean
    implements Processor {
        private String tapped;

        public void process(Exchange exchange) {
            this.tapped = (String)exchange.getIn().getBody(String.class);
        }

        public String getTapped() {
            return this.tapped;
        }
    }
}

