/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ThreadPoolBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.util.concurrent.ThreadPoolRejectedPolicy;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledIfSystemProperty;
import org.junit.jupiter.api.parallel.Isolated;

@DisabledIfSystemProperty(named="camel.threads.virtual.enabled", matches="true", disabledReason="Tasks are not rejected when using Virtual Threads")
@Isolated
public class WireTapAbortPolicyTest
extends ContextTestSupport {
    protected MockEndpoint tap;
    protected MockEndpoint result;
    protected ExecutorService pool;
    private final CountDownLatch latch = new CountDownLatch(1);
    private final CyclicBarrier barrier = new CyclicBarrier(2);

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        super.tearDown();
        if (this.pool != null) {
            this.pool.shutdownNow();
        }
    }

    @Test
    public void testSend() throws Exception {
        this.result.expectedMinimumMessageCount(2);
        this.tap.expectedMinimumMessageCount(1);
        this.template.sendBody("direct:start", (Object)"A");
        this.template.sendBody("direct:start", (Object)"B");
        try {
            this.template.sendBody("direct:start", (Object)"C");
            Assertions.fail((String)"Task should be rejected");
        }
        catch (Exception e) {
            WireTapAbortPolicyTest.assertIsInstanceOf(RejectedExecutionException.class, e.getCause());
        }
        finally {
            this.latch.countDown();
        }
        this.assertMockEndpointsSatisfied();
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.tap = this.getMockEndpoint("mock:tap");
        this.result = this.getMockEndpoint("mock:result");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ExecutorService pool = new ThreadPoolBuilder((CamelContext)WireTapAbortPolicyTest.this.context).poolSize(2).maxPoolSize(2).maxQueueSize(0).rejectedPolicy(ThreadPoolRejectedPolicy.Abort).build();
                ((RouteDefinition)this.from("direct:start").to("log:foo")).wireTap("direct:tap").executorService(pool).to("mock:result");
                ((RouteDefinition)((RouteDefinition)this.from("direct:tap").process(e -> WireTapAbortPolicyTest.this.barrier.await(5L, TimeUnit.SECONDS))).process(e -> WireTapAbortPolicyTest.this.latch.await(5L, TimeUnit.SECONDS))).to("mock:tap");
            }
        };
    }
}

