/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class WeightedRoundRobinLoadBalanceTest
extends ContextTestSupport {
    protected MockEndpoint x;
    protected MockEndpoint y;
    protected MockEndpoint z;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.x = this.getMockEndpoint("mock:x");
        this.y = this.getMockEndpoint("mock:y");
        this.z = this.getMockEndpoint("mock:z");
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testRoundRobin() throws Exception {
        this.x.expectedMessageCount(5);
        this.y.expectedMessageCount(2);
        this.z.expectedMessageCount(1);
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").loadBalance().weighted(true, "4,2,1").to(new String[]{"mock:x", "mock:y", "mock:z"});
            }
        });
        this.context.start();
        this.sendMessages(1, 2, 3, 4, 5, 6, 7, 8);
        this.assertMockEndpointsSatisfied();
        this.x.expectedBodiesReceived(new Object[]{1, 4, 6, 7, 8});
        this.y.expectedBodiesReceived(new Object[]{2, 5});
        this.z.expectedBodiesReceived(new Object[]{3});
    }

    @Test
    public void testRoundRobin2() throws Exception {
        this.x.expectedMessageCount(3);
        this.y.expectedMessageCount(1);
        this.z.expectedMessageCount(3);
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").loadBalance().weighted(true, "2, 1, 3", ",").to(new String[]{"mock:x", "mock:y", "mock:z"});
            }
        });
        this.context.start();
        this.sendMessages(1, 2, 3, 4, 5, 6, 7);
        this.assertMockEndpointsSatisfied();
        this.x.expectedBodiesReceived(new Object[]{1, 4, 7});
        this.y.expectedBodiesReceived(new Object[]{2});
        this.z.expectedBodiesReceived(new Object[]{3, 5, 6});
    }

    @Test
    public void testRoundRobinBulk() throws Exception {
        this.x.expectedMessageCount(10);
        this.y.expectedMessageCount(15);
        this.z.expectedMessageCount(25);
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").loadBalance().weighted(true, "2-3-5", "-").to(new String[]{"mock:x", "mock:y", "mock:z"});
            }
        });
        this.context.start();
        this.sendBulkMessages(50);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testUnmatchedRatiosToProcessors() {
        try {
            this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() {
                    this.from("direct:start").loadBalance().weighted(true, "2,3").to(new String[]{"mock:x", "mock:y", "mock:z"});
                }
            });
            this.context.start();
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (Exception e) {
            IllegalArgumentException iae = WeightedRoundRobinLoadBalanceTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause().getCause());
            Assertions.assertEquals((Object)"Loadbalacing with 3 should match number of distributions 2", (Object)iae.getMessage());
        }
    }

    protected void sendBulkMessages(int number) {
        for (int i = 0; i < number; ++i) {
            this.template.sendBodyAndHeader("direct:start", (Object)this.createTestMessage(i), "counter", (Object)i);
        }
    }

    protected void sendMessages(int ... counters) {
        for (int counter : counters) {
            this.template.sendBodyAndHeader("direct:start", (Object)this.createTestMessage(counter), "counter", (Object)counter);
        }
    }

    private String createTestMessage(int counter) {
        return "<message>" + counter + "</message>";
    }
}

