/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.ValidationException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.TryDefinition;
import org.apache.camel.processor.MyValidator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ValidationTest
extends ContextTestSupport {
    protected final Processor validator = new MyValidator();
    protected MockEndpoint validEndpoint;
    protected MockEndpoint invalidEndpoint;

    @Test
    public void testValidMessage() throws Exception {
        this.validEndpoint.expectedMessageCount(1);
        this.invalidEndpoint.expectedMessageCount(0);
        Object result = this.template.requestBodyAndHeader("direct:start", (Object)"<valid/>", "foo", (Object)"bar");
        Assertions.assertEquals((Object)"validResult", (Object)result);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testInvalidMessage() throws Exception {
        this.validEndpoint.expectedMessageCount(0);
        this.invalidEndpoint.expectedMessageCount(1);
        try {
            this.template.sendBodyAndHeader("direct:start", (Object)"<invalid/>", "foo", (Object)"notMatchedHeaderValue");
        }
        catch (RuntimeCamelException runtimeCamelException) {
            // empty catch block
        }
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testinvalidThenValidMessage() throws Exception {
        this.validEndpoint.expectedMessageCount(2);
        this.invalidEndpoint.expectedMessageCount(1);
        try {
            this.template.sendBodyAndHeader("direct:start", (Object)"<invalid/>", "foo", (Object)"notMatchedHeaderValue");
        }
        catch (RuntimeCamelException runtimeCamelException) {
            // empty catch block
        }
        Object result = this.template.requestBodyAndHeader("direct:start", (Object)"<valid/>", "foo", (Object)"bar");
        Assertions.assertEquals((Object)"validResult", (Object)result);
        result = this.template.requestBodyAndHeader("direct:start", (Object)"<valid/>", "foo", (Object)"bar");
        Assertions.assertEquals((Object)"validResult", (Object)result);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.validEndpoint = this.resolveMandatoryEndpoint("mock:valid", MockEndpoint.class);
        this.invalidEndpoint = this.resolveMandatoryEndpoint("mock:invalid", MockEndpoint.class);
        this.validEndpoint.whenAnyExchangeReceived(e -> e.getMessage().setBody((Object)"validResult"));
        this.invalidEndpoint.whenAnyExchangeReceived(e -> e.getMessage().setBody((Object)"invalidResult"));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((TryDefinition)((TryDefinition)this.from("direct:start").doTry().process(ValidationTest.this.validator)).to("mock:valid")).doCatch(ValidationException.class).to("mock:invalid");
            }
        };
    }
}

