/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.TryDefinition;
import org.apache.camel.processor.MyValidator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ValidationFinallyBlockNoCatchTest
extends ContextTestSupport {
    protected final Processor validator = new MyValidator();
    protected MockEndpoint validEndpoint;
    protected MockEndpoint allEndpoint;
    protected MockEndpoint deadEndpoint;

    @Test
    public void testValidMessage() throws Exception {
        this.validEndpoint.expectedMessageCount(1);
        this.allEndpoint.expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"<valid/>", "foo", (Object)"bar");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testInvalidMessage() throws Exception {
        this.validEndpoint.expectedMessageCount(0);
        this.allEndpoint.expectedMessageCount(1);
        this.deadEndpoint.expectedMessageCount(0);
        try {
            this.template.sendBodyAndHeader("direct:start", (Object)"<invalid/>", "foo", (Object)"notMatchedHeaderValue");
            Assertions.fail((String)"Should have thrown an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertMockEndpointsSatisfied();
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.validEndpoint = this.resolveMandatoryEndpoint("mock:valid", MockEndpoint.class);
        this.allEndpoint = this.resolveMandatoryEndpoint("mock:all", MockEndpoint.class);
        this.deadEndpoint = this.resolveMandatoryEndpoint("mock:dead", MockEndpoint.class);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:dead").redeliveryDelay(0L).maximumRedeliveries(3).logStackTrace(false));
                ((TryDefinition)((TryDefinition)this.from("direct:start").doTry().process(ValidationFinallyBlockNoCatchTest.this.validator)).to("mock:valid")).doFinally().to("mock:all");
            }
        };
    }
}

