/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.processor.ValidatingProcessorTest;
import org.apache.camel.support.processor.validation.SchemaValidationException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ValidatingDomProcessorTest
extends ValidatingProcessorTest {
    @Override
    @Test
    public void testNonWellFormedXml() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:invalid");
        mock.expectedMessageCount(1);
        String xml = "<?xml version=\"1.0\" encoding=\"iso-8859-1\"?>user xmlns=\"http://foo.com/bar\">  <id>1</id>  <username>davsclaus</username>";
        try {
            this.template.sendBody("direct:start", (Object)xml);
            Assertions.fail((String)"Should have thrown a RuntimeCamelException");
        }
        catch (CamelExecutionException e) {
            ValidatingDomProcessorTest.assertIsInstanceOf(SchemaValidationException.class, e.getCause());
        }
        this.assertMockEndpointsSatisfied();
    }
}

