/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.ValidateDefinition;
import org.apache.camel.spi.PredicateExceptionFactory;
import org.apache.camel.support.processor.PredicateValidationException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ValidatePredicateExceptionFactoryTest
extends ContextTestSupport {
    protected Endpoint startEndpoint;
    protected MockEndpoint resultEndpoint;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.startEndpoint = this.resolveMandatoryEndpoint("direct:start", Endpoint.class);
        this.resultEndpoint = this.resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
    }

    @Test
    public void testSendMatchingMessage() throws Exception {
        this.resultEndpoint.expectedMessageCount(1);
        this.template.sendBody(this.startEndpoint, (Object)"Hello Camel");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSendNotMatchingMessage() throws Exception {
        this.resultEndpoint.expectedMessageCount(0);
        try {
            this.template.sendBody(this.startEndpoint, (Object)"Bye World");
            Assertions.fail((String)"CamelExecutionException expected");
        }
        catch (CamelExecutionException e) {
            ValidatePredicateExceptionFactoryTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            String s = "Dude was here myValidate";
            ValidatePredicateExceptionFactoryTest.assertStringContains(e.getCause().getMessage(), s);
        }
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSkip() throws Exception {
        this.resultEndpoint.expectedMessageCount(0);
        try {
            this.template.sendBody(this.startEndpoint, (Object)"Skip World");
            Assertions.fail((String)"CamelExecutionException expected");
        }
        catch (CamelExecutionException e) {
            ValidatePredicateExceptionFactoryTest.assertIsInstanceOf(PredicateValidationException.class, e.getCause());
        }
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ExpressionNode)((ValidateDefinition)this.from("direct:start").validate().simple("${body} contains 'Camel'")).predicateExceptionFactory((PredicateExceptionFactory)new MyExceptionFactory()).id("myValidate")).to("mock:result");
            }
        };
    }

    private static class MyExceptionFactory
    implements PredicateExceptionFactory {
        private MyExceptionFactory() {
        }

        public Exception newPredicateException(Exchange exchange, Predicate predicate, String id) {
            if (((String)exchange.getMessage().getBody(String.class)).startsWith("Skip")) {
                return null;
            }
            throw new IllegalArgumentException("Dude was here " + id);
        }
    }
}

