/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.support.service.ServiceSupport;
import org.junit.jupiter.api.Test;

public class UnmarshalVariableTest
extends ContextTestSupport {
    @Test
    public void testSend() throws Exception {
        this.getMockEndpoint("mock:before").expectedBodiesReceived(new Object[]{"World"});
        this.getMockEndpoint("mock:before").expectedVariableReceived("hello", (Object)"Camel");
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye Camel"});
        this.getMockEndpoint("mock:result").expectedVariableReceived("hello", (Object)"Camel");
        this.template.sendBody("direct:send", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testReceive() throws Exception {
        this.getMockEndpoint("mock:after").expectedBodiesReceived(new Object[]{"World"});
        this.getMockEndpoint("mock:after").expectedVariableReceived("bye", (Object)"Bye World");
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:result").expectedVariableReceived("bye", (Object)"Bye World");
        this.template.sendBody("direct:receive", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSendAndReceive() throws Exception {
        this.getMockEndpoint("mock:before").expectedBodiesReceived(new Object[]{"World"});
        this.getMockEndpoint("mock:before").expectedVariableReceived("hello", (Object)"Camel");
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"World"});
        this.getMockEndpoint("mock:result").expectedVariableReceived("bye", (Object)"Bye Camel");
        this.template.sendBody("direct:sendAndReceive", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                UnmarshalVariableTest.this.context.getRegistry().bind("myDF", (Object)new MyByeDataFormat());
                ((RouteDefinition)((RouteDefinition)this.from("direct:send").setVariable("hello", (Expression)this.simple("Camel"))).to("mock:before")).unmarshal().variableSend("hello").custom("myDF").to("mock:result");
                ((RouteDefinition)((RouteDefinition)this.from("direct:receive").unmarshal().variableReceive("bye").custom("myDF").to("mock:after")).setBody((Expression)this.simple("${variable:bye}"))).to("mock:result");
                ((RouteDefinition)((RouteDefinition)this.from("direct:sendAndReceive").setVariable("hello", (Expression)this.simple("Camel"))).to("mock:before")).unmarshal().variableSend("hello").variableReceive("bye").custom("myDF").to("mock:result");
            }
        };
    }

    public static class MyByeDataFormat
    extends ServiceSupport
    implements DataFormat {
        public void marshal(Exchange exchange, Object graph, OutputStream stream) {
        }

        public Object unmarshal(Exchange exchange, InputStream stream) {
            return "Bye " + (String)exchange.getContext().getTypeConverter().convertTo(String.class, exchange, (Object)stream);
        }
    }
}

