/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.TestSupport;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.support.DefaultMessage;
import org.apache.camel.support.processor.UnmarshalProcessor;
import org.apache.camel.support.service.ServiceSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UnmarshalProcessorTest
extends TestSupport {
    @Test
    public void testDataFormatReturnsSameExchange() throws Exception {
        Exchange exchange = this.createExchangeWithBody((CamelContext)new DefaultCamelContext(), "body");
        UnmarshalProcessor processor = new UnmarshalProcessor((DataFormat)new MyDataFormat(exchange));
        processor.process(exchange);
        Assertions.assertEquals((Object)"body", (Object)exchange.getMessage().getBody(), (String)"UnmarshalProcessor did not copy OUT from IN message");
    }

    @Test
    public void testDataFormatReturnsAnotherExchange() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        Exchange exchange = this.createExchangeWithBody((CamelContext)context, "body");
        Exchange exchange2 = this.createExchangeWithBody((CamelContext)context, "body2");
        UnmarshalProcessor processor = new UnmarshalProcessor((DataFormat)new MyDataFormat(exchange2));
        exchange.getExchangeId();
        exchange2.getExchangeId();
        processor.process(exchange);
        Exception e = exchange.getException();
        Assertions.assertNotNull((Object)e);
        Assertions.assertEquals((Object)("The returned exchange " + String.valueOf(exchange2) + " is not the same as " + String.valueOf(exchange) + " provided to the DataFormat"), (Object)e.getMessage());
    }

    @Test
    public void testDataFormatReturnsMessage() throws Exception {
        Exchange exchange = this.createExchangeWithBody((CamelContext)new DefaultCamelContext(), "body");
        DefaultMessage out = new DefaultMessage(exchange.getContext());
        out.setBody(new Object());
        UnmarshalProcessor processor = new UnmarshalProcessor((DataFormat)new MyDataFormat((Message)out));
        processor.process(exchange);
        Assertions.assertSame((Object)out, (Object)exchange.getMessage(), (String)"UnmarshalProcessor did not make use of the returned OUT message");
        Assertions.assertSame((Object)out.getBody(), (Object)exchange.getMessage().getBody(), (String)"UnmarshalProcessor did change the body bound to the OUT message");
    }

    @Test
    public void testDataFormatReturnsBody() throws Exception {
        Exchange exchange = this.createExchangeWithBody((CamelContext)new DefaultCamelContext(), "body");
        Object unmarshalled = new Object();
        UnmarshalProcessor processor = new UnmarshalProcessor((DataFormat)new MyDataFormat(unmarshalled));
        processor.process(exchange);
        Assertions.assertSame((Object)unmarshalled, (Object)exchange.getMessage().getBody(), (String)"UnmarshalProcessor did not make use of the returned object being returned while unmarshalling");
    }

    @Test
    public void testAllowNullBody() throws Exception {
        Exchange exchange = this.createExchangeWithBody((CamelContext)new DefaultCamelContext(), null);
        UnmarshalProcessor processor = new UnmarshalProcessor((DataFormat)new MyDataFormat(exchange), true);
        processor.process(exchange);
        Assertions.assertNull((Object)exchange.getMessage().getBody(), (String)"UnmarshalProcessor should allow null body");
        Assertions.assertNull((Object)exchange.getException(), (String)"UnmarshalProcessor should allow null body");
    }

    private static class MyDataFormat
    extends ServiceSupport
    implements DataFormat {
        private final Object object;

        MyDataFormat(Exchange exchange) {
            this.object = exchange;
        }

        MyDataFormat(Message message) {
            this.object = message;
        }

        MyDataFormat(Object unmarshalled) {
            this.object = unmarshalled;
        }

        public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
            throw new IllegalAccessException("This method is not expected to be used by UnmarshalProcessor");
        }

        public Object unmarshal(Exchange exchange, InputStream stream) {
            return this.object;
        }
    }
}

