/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spi.Synchronization;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class UnitOfWorkTest
extends ContextTestSupport {
    protected Synchronization synchronization;
    protected Exchange completed;
    protected Exchange failed;
    protected String uri = "direct:foo";
    protected final CountDownLatch doneLatch = new CountDownLatch(1);
    protected Object foo;
    protected Object baz;

    @Test
    public void testSuccess() throws Exception {
        this.sendMessage();
        Assertions.assertTrue((boolean)this.doneLatch.await(5L, TimeUnit.SECONDS), (String)"Exchange did not complete.");
        Assertions.assertNull((Object)this.failed, (String)"Should not have failed");
        Assertions.assertNotNull((Object)this.completed, (String)"Should have received completed notification");
        Assertions.assertEquals((Object)"bar", (Object)this.foo, (String)"Should have propagated the header inside the Synchronization.onComplete() callback");
        Assertions.assertNull((Object)this.baz, (String)"The Synchronization.onFailure() callback should have not been invoked");
        this.log.info("Received completed: {}", (Object)this.completed);
    }

    @Test
    public void testException() throws Exception {
        this.sendMessage();
        Assertions.assertTrue((boolean)this.doneLatch.await(5L, TimeUnit.SECONDS), (String)"Exchange did not complete.");
        Assertions.assertNull((Object)this.completed, (String)"Should not have completed");
        Assertions.assertNotNull((Object)this.failed, (String)"Should have received failed notification");
        Assertions.assertEquals((Object)"bat", (Object)this.baz, (String)"Should have propagated the header inside the Synchronization.onFailure() callback");
        Assertions.assertNull((Object)this.foo, (String)"The Synchronization.onComplete() callback should have not been invoked");
        this.log.info("Received fail: {}", (Object)this.failed);
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        this.synchronization = new Synchronization(){

            public void onComplete(Exchange exchange) {
                UnitOfWorkTest.this.completed = exchange;
                UnitOfWorkTest.this.foo = exchange.getIn().getHeader("foo");
                UnitOfWorkTest.this.doneLatch.countDown();
            }

            public void onFailure(Exchange exchange) {
                UnitOfWorkTest.this.failed = exchange;
                UnitOfWorkTest.this.baz = exchange.getIn().getHeader("baz");
                UnitOfWorkTest.this.doneLatch.countDown();
            }
        };
        super.setUp();
    }

    protected void sendMessage() {
        this.template.send(this.uri, new Processor(){

            public void process(Exchange exchange) {
                exchange.getIn().setHeader("foo", (Object)"bar");
                exchange.getIn().setHeader("baz", (Object)"bat");
                exchange.getIn().setBody((Object)"<hello>world!</hello>");
            }
        });
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("seda:async").to("direct:foo");
                this.from("direct:foo").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        log.info("Received: {}", (Object)exchange);
                        exchange.getUnitOfWork().addSynchronization(UnitOfWorkTest.this.synchronization);
                        String name = UnitOfWorkTest.this.getName();
                        if (name.equals("testException")) {
                            log.info("Throwing exception!");
                            throw new Exception("Failing test!");
                        }
                    }
                });
            }
        };
    }
}

