/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.support.EventNotifierSupport;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UnitOfWorkProducerTest
extends ContextTestSupport {
    private static final List<CamelEvent> events = new ArrayList<CamelEvent>();

    @Override
    protected CamelContext createCamelContext() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext(this.createCamelRegistry());
        context.getManagementStrategy().addEventNotifier((EventNotifier)new EventNotifierSupport(){

            public void notify(CamelEvent event) {
                events.add(event);
            }

            public boolean isEnabled(CamelEvent event) {
                return event instanceof CamelEvent.ExchangeCompletedEvent;
            }
        });
        return context;
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        events.clear();
        super.tearDown();
    }

    @Test
    public void testSedaBasedUnitOfWorkProducer() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesWaitTime();
        Assertions.assertEquals((int)2, (int)events.size());
    }

    @Test
    public void testDirectBasedUnitOfWorkProducer() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:bar", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesWaitTime();
        Assertions.assertEquals((int)1, (int)events.size());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("seda:foo").to("mock:result");
                this.from("direct:bar").to("mock:result");
            }
        };
    }
}

