/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileMessage;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.seda.SedaEndpoint;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.support.EventNotifierSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UnitOfWorkHelperTest
extends ContextTestSupport {
    private static final String FILE_CONTENT = "Lorem ipsum dolor sit amet";
    private SedaEndpoint fromEndpoint;
    private int numberOfExchangeCreatedEvents;

    @Test
    void testUoWShouldBeClearedOnJobDone() {
        MockEndpoint resultEndpoint = (MockEndpoint)this.context.getEndpoint("mock:result", MockEndpoint.class);
        this.fromEndpoint = (SedaEndpoint)this.context.getEndpoint("seda:from", SedaEndpoint.class);
        CustomEventNotifier eventNotifier = new CustomEventNotifier();
        this.context.getManagementStrategy().addEventNotifier((EventNotifier)eventNotifier);
        Exchange testExchange = this.createExchange("testFile");
        this.template.send((Endpoint)this.fromEndpoint, testExchange);
        this.template.send((Endpoint)this.fromEndpoint, testExchange);
        Assertions.assertEquals((int)2, (int)this.numberOfExchangeCreatedEvents);
    }

    private Exchange createExchange(String fileName) {
        DefaultExchange testExchange = new DefaultExchange((CamelContext)this.context);
        GenericFile<String> testFile = this.createFile(fileName);
        GenericFileMessage testMessage = new GenericFileMessage((Exchange)testExchange, testFile);
        testMessage.setBody(testFile);
        testExchange.setIn((Message)testMessage);
        testExchange.getExchangeExtension().setFromEndpoint((Endpoint)this.fromEndpoint);
        testExchange.setProperty("CamelFileExchangeFile", testFile);
        return testExchange;
    }

    private GenericFile<String> createFile(String fileName) {
        GenericFile testFile = new GenericFile();
        testFile.setFile((Object)FILE_CONTENT);
        testFile.setAbsoluteFilePath(fileName);
        testFile.setBody((Object)FILE_CONTENT);
        return testFile;
    }

    public class CustomEventNotifier
    extends EventNotifierSupport {
        public void notify(CamelEvent event) {
            if (event instanceof CamelEvent.ExchangeCreatedEvent) {
                ++UnitOfWorkHelperTest.this.numberOfExchangeCreatedEvents;
            }
        }
    }
}

