/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class TypeConverterRegistryStatsPerformanceTest
extends ContextTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.setTypeConverterStatisticsEnabled(Boolean.valueOf(true));
        return context;
    }

    @Test
    public void testTransform() throws Exception {
        long noop = this.context.getTypeConverterRegistry().getStatistics().getNoopCounter();
        long attempt = this.context.getTypeConverterRegistry().getStatistics().getAttemptCounter();
        long failed = this.context.getTypeConverterRegistry().getStatistics().getFailedCounter();
        long hit = this.context.getTypeConverterRegistry().getStatistics().getHitCounter();
        long miss = this.context.getTypeConverterRegistry().getStatistics().getMissCounter();
        int size = 1000;
        this.getMockEndpoint("mock:result").expectedMessageCount(size);
        for (int i = 0; i < size; ++i) {
            this.template.sendBody("direct:start", (Object)"World");
        }
        this.assertMockEndpointsSatisfied();
        long noop2 = this.context.getTypeConverterRegistry().getStatistics().getNoopCounter();
        long attempt2 = this.context.getTypeConverterRegistry().getStatistics().getAttemptCounter();
        long failed2 = this.context.getTypeConverterRegistry().getStatistics().getFailedCounter();
        long hit2 = this.context.getTypeConverterRegistry().getStatistics().getHitCounter();
        long miss2 = this.context.getTypeConverterRegistry().getStatistics().getMissCounter();
        this.log.info("Noop: before={}, after={}, delta={}", new Object[]{noop, noop2, noop2 - noop});
        this.log.info("Attempt: before={}, after={}, delta={}", new Object[]{attempt, attempt2, attempt2 - attempt});
        this.log.info("Failed: before={}, after={}, delta={}", new Object[]{failed, failed2, failed2 - failed});
        this.log.info("Hit: before={}, after={}, delta={}", new Object[]{hit, hit2, hit2 - hit});
        this.log.info("Miss: before={}, after={}, delta={}", new Object[]{miss, miss2, miss2 - miss});
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((ProcessorDefinition)this.from("direct:start").transform().method(TypeConverterRegistryStatsPerformanceTest.class, "transformMe")).bean(TypeConverterRegistryStatsPerformanceTest.class, "transformMeAlso")).to("mock:result");
            }
        };
    }

    public String transformMe(String in) {
        return "Hello " + in;
    }

    public String transformMeAlso(String in) {
        return "Bye " + in;
    }
}

