/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelContext;
import org.apache.camel.CamelException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.TestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.TryDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TryProcessorTest
extends ContextTestSupport {
    private boolean handled;

    @Test
    public void testTryCatchFinallyProcessor() throws Exception {
        this.testTryCatchFinally("direct:processor");
    }

    @Test
    public void testTryCatchFinallyExpression() throws Exception {
        this.testTryCatchFinally("direct:expression");
    }

    @Test
    public void testTryCatchFinallyPredicate() throws Exception {
        this.testTryCatchFinally("direct:predicate");
    }

    private void testTryCatchFinally(String endpointName) throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        this.getMockEndpoint("mock:last").expectedMessageCount(1);
        this.getMockEndpoint("mock:finally").expectedMessageCount(1);
        this.sendBody(endpointName, "<test>Hello World!</test>");
        Assertions.assertTrue((boolean)this.handled, (String)"Should have been handled");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)this.from("direct:processor").doTry().process((Processor)new ProcessorFail())).to("mock:result")).doCatch(CamelException.class).process((Processor)new ProcessorHandle())).doFinally().to("mock:finally")).end().to("mock:last");
                ((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)this.from("direct:expression").doTry().setBody((Expression)new ProcessorFail())).to("mock:result")).doCatch(CamelException.class).process((Processor)new ProcessorHandle())).doFinally().to("mock:finally")).end().to("mock:last");
                ((TryDefinition)((TryDefinition)((TryDefinition)this.from("direct:predicate").doTry().to("direct:sub-predicate")).doCatch(CamelException.class).process((Processor)new ProcessorHandle())).doFinally().to("mock:finally")).end().to("mock:last");
                this.from("direct:sub-predicate").errorHandler((ErrorHandlerFactory)this.noErrorHandler()).filter((Predicate)new ProcessorFail()).to("mock:result");
            }
        };
    }

    private class ProcessorHandle
    implements Processor {
        private ProcessorHandle() {
        }

        public void process(Exchange exchange) {
            TryProcessorTest.this.handled = true;
            Assertions.assertFalse((boolean)exchange.isFailed(), (String)"Should not be marked as failed");
            Exception e = (Exception)exchange.getProperty("CamelExceptionCaught");
            Assertions.assertNotNull((Object)e, (String)"There should be an exception");
            CamelException cause = TestSupport.assertIsInstanceOf(CamelException.class, e.getCause());
            Assertions.assertNotNull((Object)cause);
            Assertions.assertEquals((Object)"Force to fail", (Object)cause.getMessage());
        }
    }

    private static class ProcessorFail
    implements Processor,
    Predicate,
    Expression {
        private ProcessorFail() {
        }

        public void process(Exchange exchange) {
            throw new RuntimeCamelException((Throwable)new CamelException("Force to fail"));
        }

        public <T> T evaluate(Exchange exchange, Class<T> type) {
            throw new RuntimeCamelException((Throwable)new CamelException("Force to fail"));
        }

        public boolean matches(Exchange exchange) {
            throw new RuntimeCamelException((Throwable)new CamelException("Force to fail"));
        }

        public void init(CamelContext context) {
        }
    }
}

