/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.TryDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TryProcessorHandleWrappedExceptionTest
extends ContextTestSupport {
    private boolean handled;

    @Test
    public void testTryCatchFinally() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        this.getMockEndpoint("mock:finally").expectedMessageCount(1);
        this.sendBody("direct:start", "<test>Hello World!</test>");
        Assertions.assertTrue((boolean)this.handled, (String)"Should have been handled");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)this.from("direct:start").doTry().process((Processor)new ProcessorFail())).to("mock:result")).doCatch(IllegalStateException.class).process((Processor)new ProcessorHandle())).doFinally().to("mock:finally")).end();
            }
        };
    }

    private class ProcessorHandle
    implements Processor {
        private ProcessorHandle() {
        }

        public void process(Exchange exchange) {
            TryProcessorHandleWrappedExceptionTest.this.handled = true;
            Assertions.assertFalse((boolean)exchange.isFailed(), (String)"Should not be marked as failed");
            Exception e = (Exception)exchange.getProperty("CamelExceptionCaught");
            Assertions.assertNotNull((Object)e, (String)"There should be an exception");
            boolean b = e instanceof IllegalStateException;
            Assertions.assertTrue((boolean)b);
            Assertions.assertEquals((Object)"Force to fail", (Object)e.getMessage());
        }
    }

    private static class ProcessorFail
    implements Processor {
        private ProcessorFail() {
        }

        public void process(Exchange exchange) {
            throw new IllegalStateException("Force to fail");
        }
    }
}

