/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.TryDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TryFinallyCaughtExceptionTest
extends ContextTestSupport {
    @Test
    public void testTryFinallyCaughtException() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        MockEndpoint error = this.getMockEndpoint("mock:b");
        error.expectedMessageCount(1);
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            Assertions.fail((String)"Should have thrown an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertMockEndpointsSatisfied();
        Exception e = (Exception)((Exchange)error.getReceivedExchanges().get(0)).getProperty("CamelExceptionCaught", Exception.class);
        Assertions.assertNotNull((Object)e);
        Assertions.assertEquals((Object)"Forced", (Object)e.getMessage());
        String to = (String)((Exchange)error.getReceivedExchanges().get(0)).getProperty("CamelFailureEndpoint", String.class);
        Assertions.assertEquals((Object)"bean://myBean?method=doSomething", (Object)to);
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("myBean", (Object)this);
        return jndi;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((TryDefinition)((TryDefinition)((TryDefinition)this.from("direct:start").doTry().to("mock:a")).to("bean:myBean?method=doSomething")).doFinally().to("mock:b")).end().to("mock:result");
            }
        };
    }

    public void doSomething(String body) {
        throw new IllegalArgumentException("Forced");
    }
}

