/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.TryDefinition;
import org.junit.jupiter.api.Test;

public class TryCatchNestedChoiceTest
extends ContextTestSupport {
    @Test
    public void testFoo() throws Exception {
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:other").expectedMessageCount(0);
        this.getMockEndpoint("mock:catch").expectedMessageCount(0);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)123);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testOther() throws Exception {
        this.getMockEndpoint("mock:foo").expectedMessageCount(0);
        this.getMockEndpoint("mock:other").expectedMessageCount(1);
        this.getMockEndpoint("mock:catch").expectedMessageCount(0);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello Bar", "bar", (Object)456);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testCatch() throws Exception {
        this.getMockEndpoint("mock:foo").expectedMessageCount(0);
        this.getMockEndpoint("mock:other").expectedMessageCount(0);
        this.getMockEndpoint("mock:catch").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Kaboom");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((TryDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((TryDefinition)this.from("direct:start").doTry().to("direct:bar")).choice().when().simple("${header.foo} == 123")).to("mock:foo")).otherwise().to("mock:other")).endDoTry().doCatch(Exception.class).to("mock:catch")).end();
                this.from("direct:bar").process(new Processor(){

                    public void process(Exchange exchange) {
                        String body = (String)exchange.getIn().getBody(String.class);
                        if (body.contains("Kaboom")) {
                            throw new IllegalArgumentException("Forced error");
                        }
                    }
                });
            }
        };
    }
}

