/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.TryDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TryCatchCaughtExceptionTest
extends ContextTestSupport {
    @Test
    public void testTryCatchCaughtException() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("myBean", (Object)this);
        return jndi;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((TryDefinition)((TryDefinition)((TryDefinition)this.from("direct:start").doTry().to("mock:a")).to("bean:myBean?method=doSomething")).doCatch(Exception.class).process(new Processor(){

                    public void process(Exchange exchange) {
                        Assertions.assertEquals((Object)"bean://myBean?method=doSomething", (Object)exchange.getProperty("CamelFailureEndpoint"));
                        Assertions.assertEquals((Object)"Forced", (Object)((Exception)exchange.getProperty("CamelExceptionCaught", Exception.class)).getMessage());
                    }
                })).end().to("mock:result");
            }
        };
    }

    public void doSomething(String body) {
        throw new IllegalArgumentException("Forced");
    }
}

