/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.NamedNode;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.support.PluginHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TripleNestedChoiceIssueTest
extends ContextTestSupport {
    @Test
    public void testNestedChoiceVeryBig() throws Exception {
        this.getMockEndpoint("mock:low").expectedMessageCount(0);
        this.getMockEndpoint("mock:med").expectedMessageCount(0);
        this.getMockEndpoint("mock:big").expectedMessageCount(0);
        this.getMockEndpoint("mock:verybig").expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)20);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testNestedChoiceBig() throws Exception {
        this.getMockEndpoint("mock:low").expectedMessageCount(0);
        this.getMockEndpoint("mock:med").expectedMessageCount(0);
        this.getMockEndpoint("mock:big").expectedMessageCount(1);
        this.getMockEndpoint("mock:verybig").expectedMessageCount(0);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)10);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testNestedChoiceMed() throws Exception {
        this.getMockEndpoint("mock:low").expectedMessageCount(0);
        this.getMockEndpoint("mock:med").expectedMessageCount(1);
        this.getMockEndpoint("mock:big").expectedMessageCount(0);
        this.getMockEndpoint("mock:verybig").expectedMessageCount(0);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)4);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testNestedChoiceLow() throws Exception {
        String xml = PluginHelper.getModelToXMLDumper((CamelContext)this.context).dumpModelAsXml((CamelContext)this.context, (NamedNode)this.context.getRouteDefinition("route1"));
        Assertions.assertNotNull((Object)xml);
        this.log.info(xml);
        this.getMockEndpoint("mock:low").expectedMessageCount(1);
        this.getMockEndpoint("mock:med").expectedMessageCount(0);
        this.getMockEndpoint("mock:big").expectedMessageCount(0);
        this.getMockEndpoint("mock:verybig").expectedMessageCount(0);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)1);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").choice().when(this.header("foo").isGreaterThan((Object)1)).choice().when(this.header("foo").isGreaterThan((Object)5)).choice().when(this.header("foo").isGreaterThan((Object)10)).to("mock:verybig")).otherwise().to("mock:big")).end().endChoice().otherwise().to("mock:med")).end().endChoice().otherwise().to("mock:low")).end();
            }
        };
    }
}

