/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.ProcessorDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.w3c.dom.NodeList;

public class TransformXpathTest
extends ContextTestSupport {
    @Test
    public void testTransformWithXpath() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        ((MockValueBuilder)mock.message(0).body()).isInstanceOf(NodeList.class);
        String xml = (String)this.context.getTypeConverter().convertTo(String.class, (Object)new File("src/test/resources/org/apache/camel/processor/students.xml"));
        this.template.sendBody("direct:start", (Object)xml);
        this.assertMockEndpointsSatisfied();
        NodeList list = (NodeList)((Exchange)mock.getReceivedExchanges().get(0)).getIn().getBody(NodeList.class);
        Assertions.assertEquals((int)2, (int)list.getLength());
        Assertions.assertEquals((Object)"Claus", (Object)this.context.getTypeConverter().convertTo(String.class, (Object)list.item(0).getTextContent().trim()));
        Assertions.assertEquals((Object)"Hadrian", (Object)this.context.getTypeConverter().convertTo(String.class, (Object)list.item(1).getTextContent().trim()));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ProcessorDefinition)this.from("direct:start").transform().xpath("//students/student")).to("mock:result");
            }
        };
    }
}

