/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class ToVariableTest
extends ContextTestSupport {
    @Test
    public void testSend() throws Exception {
        this.getMockEndpoint("mock:before").expectedBodiesReceived(new Object[]{"World"});
        this.getMockEndpoint("mock:before").expectedVariableReceived("hello", (Object)"Camel");
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye Camel"});
        this.getMockEndpoint("mock:result").expectedVariableReceived("hello", (Object)"Camel");
        this.template.sendBody("direct:send", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testReceive() throws Exception {
        this.getMockEndpoint("mock:after").expectedBodiesReceived(new Object[]{"World"});
        this.getMockEndpoint("mock:after").expectedVariableReceived("bye", (Object)"Bye World");
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:result").expectedVariableReceived("bye", (Object)"Bye World");
        this.template.sendBody("direct:receive", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSendAndReceive() throws Exception {
        this.getMockEndpoint("mock:before").expectedBodiesReceived(new Object[]{"World"});
        this.getMockEndpoint("mock:before").expectedVariableReceived("hello", (Object)"Camel");
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"World"});
        this.getMockEndpoint("mock:result").expectedVariableReceived("bye", (Object)"Bye Camel");
        this.template.sendBody("direct:sendAndReceive", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:send").setVariable("hello", (Expression)this.simple("Camel"))).to("mock:before")).toV("direct:foo", "hello", null)).to("mock:result");
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:receive").toV("direct:foo", null, "bye")).to("mock:after")).setBody((Expression)this.variable("bye"))).to("mock:result");
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:sendAndReceive").setVariable("hello", (Expression)this.simple("Camel"))).to("mock:before")).toV("direct:foo", "hello", "bye")).to("mock:result");
                this.from("direct:foo").transform().simple("Bye ${body}");
            }
        };
    }
}

