/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class ToVariableReceiveTest
extends ContextTestSupport {
    @Test
    public void testReceive() throws Exception {
        this.getMockEndpoint("mock:after").expectedBodiesReceived(new Object[]{"World"});
        this.getMockEndpoint("mock:after").expectedVariableReceived("bye", (Object)"Bye World");
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:result").expectedVariableReceived("bye", (Object)"Bye World");
        ((MockValueBuilder)this.getMockEndpoint("mock:result").message(0).header("foo")).isNull();
        this.template.sendBody("direct:receive", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:receive").toV("direct:foo", null, "bye")).to("mock:after")).setBody((Expression)this.variable("bye"))).to("mock:result");
                ((RouteDefinition)this.from("direct:foo").setHeader("foo", (Expression)this.constant("Foo was here"))).transform().simple("Bye ${body}");
            }
        };
    }
}

