/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.MulticastDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ToEndpointPropertyTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testSimpleToEndpoint() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        ((MockValueBuilder)mock.message(0).exchangeProperty("CamelToEndpoint")).isEqualTo((Object)"mock://result");
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testMediumToEndpoint() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to("direct:foo");
                this.from("direct:foo").to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        ((MockValueBuilder)mock.message(0).exchangeProperty("CamelToEndpoint")).isEqualTo((Object)"mock://result");
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testRecipientListToEndpoint() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").recipientList((Expression)this.header("foo"));
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        ((MockValueBuilder)mock.message(0).exchangeProperty("CamelToEndpoint")).isEqualTo((Object)"mock://result");
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"mock:result");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testRoutingSlipToEndpoint() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").routingSlip((Expression)this.header("foo"));
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        ((MockValueBuilder)mock.message(0).exchangeProperty("CamelToEndpoint")).isEqualTo((Object)"mock://result");
        MockEndpoint a = this.getMockEndpoint("mock:a");
        a.expectedMessageCount(1);
        ((MockValueBuilder)a.message(0).exchangeProperty("CamelToEndpoint")).isEqualTo((Object)"mock://a");
        MockEndpoint b = this.getMockEndpoint("mock:b");
        b.expectedMessageCount(1);
        ((MockValueBuilder)b.message(0).exchangeProperty("CamelToEndpoint")).isEqualTo((Object)"mock://b");
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"mock:a,mock:b,mock:result");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testWireTapToEndpoint() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").wireTap("mock:tap").to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        ((MockValueBuilder)mock.message(0).exchangeProperty("CamelToEndpoint")).isEqualTo((Object)"mock://result");
        MockEndpoint tap = this.getMockEndpoint("mock:tap");
        tap.expectedMessageCount(1);
        ((MockValueBuilder)tap.message(0).exchangeProperty("CamelToEndpoint")).isEqualTo((Object)"mock://tap");
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testMulticastToEndpoint() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((MulticastDefinition)this.from("direct:start").multicast().to(new String[]{"direct:a", "direct:b"})).end().process(new Processor(){

                    public void process(Exchange exchange) {
                        String to = (String)exchange.getProperty("CamelToEndpoint", String.class);
                        Assertions.assertEquals((Object)"direct://b", (Object)to);
                    }
                }).to("mock:result");
                this.from("direct:a").transform((Expression)this.constant("A"));
                this.from("direct:b").transform((Expression)this.constant("B"));
            }
        });
        this.context.start();
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(1);
        ((MockValueBuilder)result.message(0).exchangeProperty("CamelFailureEndpoint")).isNull();
        ((MockValueBuilder)result.message(0).exchangeProperty("CamelToEndpoint")).isEqualTo((Object)"mock://result");
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testDLCToEndpoint() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:dead").disableRedelivery());
                ((RouteDefinition)this.from("direct:start").to("direct:foo")).to("mock:result");
                this.from("direct:foo").throwException((Exception)new IllegalArgumentException("Damn"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        MockEndpoint dead = this.getMockEndpoint("mock:dead");
        ((MockValueBuilder)dead.message(0).exchangeProperty("CamelFailureEndpoint")).isEqualTo((Object)"direct://foo");
        ((MockValueBuilder)dead.message(0).exchangeProperty("CamelToEndpoint")).isEqualTo((Object)"mock://dead");
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testMediumDLCToEndpoint() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("direct:dead").disableRedelivery());
                ((RouteDefinition)this.from("direct:start").to("direct:foo")).to("mock:result");
                this.from("direct:foo").throwException((Exception)new IllegalArgumentException("Damn"));
                ((RouteDefinition)((RouteDefinition)this.from("direct:dead").to("mock:a")).to("mock:b")).to("mock:dead");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        MockEndpoint dead = this.getMockEndpoint("mock:dead");
        ((MockValueBuilder)dead.message(0).exchangeProperty("CamelFailureEndpoint")).isEqualTo((Object)"direct://foo");
        ((MockValueBuilder)dead.message(0).exchangeProperty("CamelToEndpoint")).isEqualTo((Object)"mock://dead");
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testMulticastDLC() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:dead").disableRedelivery());
                this.from("direct:start").multicast().to(new String[]{"direct:a", "direct:b"});
                this.from("direct:a").transform((Expression)this.constant("A"));
                this.from("direct:b").throwException((Exception)new IllegalArgumentException("Damn"));
                this.from("direct:dead").to("mock:dead");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        MockEndpoint dead = this.getMockEndpoint("mock:dead");
        ((MockValueBuilder)dead.message(0).exchangeProperty("CamelFailureEndpoint")).isEqualTo((Object)"direct://b");
        ((MockValueBuilder)dead.message(0).exchangeProperty("CamelToEndpoint")).isEqualTo((Object)"mock://dead");
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }
}

