/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class ToDynamicVariableTest
extends ContextTestSupport {
    @Test
    public void testSend() throws Exception {
        this.getMockEndpoint("mock:before").expectedBodiesReceived(new Object[]{"World"});
        this.getMockEndpoint("mock:before").expectedVariableReceived("hello", (Object)"Camel");
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye Camel"});
        this.getMockEndpoint("mock:result").expectedVariableReceived("hello", (Object)"Camel");
        this.template.sendBodyAndHeader("direct:send", (Object)"World", "where", (Object)"foo");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testReceive() throws Exception {
        this.getMockEndpoint("mock:after").expectedBodiesReceived(new Object[]{"World"});
        this.getMockEndpoint("mock:after").expectedVariableReceived("bye", (Object)"Bye World");
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:result").expectedVariableReceived("bye", (Object)"Bye World");
        this.template.sendBodyAndHeader("direct:receive", (Object)"World", "where", (Object)"foo");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSendAndReceive() throws Exception {
        this.getMockEndpoint("mock:before").expectedBodiesReceived(new Object[]{"World"});
        this.getMockEndpoint("mock:before").expectedVariableReceived("hello", (Object)"Camel");
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"World"});
        this.getMockEndpoint("mock:result").expectedVariableReceived("bye", (Object)"Bye Camel");
        this.template.sendBodyAndHeader("direct:sendAndReceive", (Object)"World", "where", (Object)"foo");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:send").setVariable("hello", (Expression)this.simple("Camel"))).to("mock:before")).toD("direct:${header.where}", "hello", null)).to("mock:result");
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:receive").toD("direct:${header.where}", null, "bye")).to("mock:after")).setBody((Expression)this.simple("${variable:bye}"))).to("mock:result");
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:sendAndReceive").setVariable("hello", (Expression)this.simple("Camel"))).to("mock:before")).toD("direct:${header.where}", "hello", "bye")).to("mock:result");
                this.from("direct:foo").transform().simple("Bye ${body}");
            }
        };
    }
}

