/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.TryDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ToDynamicVariableErrorTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testThrowException() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:receive").toD("direct:${header.where}", null, "bye")).to("mock:result");
                ((ProcessorDefinition)this.from("direct:foo").transform().simple("Bye ${body}")).throwException((Exception)new IllegalArgumentException("Forced"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        Exchange out = this.template.request("direct:receive", e -> {
            e.getMessage().setHeader("where", (Object)"foo");
            e.getMessage().setBody((Object)"World");
        });
        Assertions.assertTrue((boolean)out.isFailed());
        Assertions.assertFalse((boolean)out.hasVariables());
        Assertions.assertEquals((Object)"Bye World", (Object)out.getMessage().getBody());
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testTryCatch() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:receive").toD("direct:${header.where}", null, "bye")).to("mock:result");
                ((TryDefinition)((TryDefinition)((ProcessorDefinition)this.from("direct:foo").transform().simple("Bye ${body}")).doTry().throwException((Exception)new IllegalArgumentException("Forced"))).doCatch(Exception.class).setBody((Expression)this.simple("Catch: ${body}"))).end();
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        Exchange out = this.template.request("direct:receive", e -> {
            e.getMessage().setHeader("where", (Object)"foo");
            e.getMessage().setBody((Object)"World");
        });
        Assertions.assertFalse((boolean)out.isFailed());
        Assertions.assertTrue((boolean)out.hasVariables());
        Assertions.assertEquals((Object)"World", (Object)out.getMessage().getBody());
        Assertions.assertEquals((Object)"Catch: Bye World", (Object)out.getVariable("bye"));
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testOnExceptionHandled() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.onException(Exception.class).handled(true).setBody((Expression)this.simple("Error: ${body}"));
                ((RouteDefinition)this.from("direct:receive").toD("direct:${header.where}", null, "bye")).to("mock:result");
                ((ProcessorDefinition)this.from("direct:foo").transform().simple("Bye ${body}")).throwException((Exception)new IllegalArgumentException("Forced"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        Exchange out = this.template.request("direct:receive", e -> {
            e.getMessage().setHeader("where", (Object)"foo");
            e.getMessage().setBody((Object)"World");
        });
        Assertions.assertFalse((boolean)out.isFailed());
        Assertions.assertFalse((boolean)out.hasVariables());
        Assertions.assertEquals((Object)"Error: Bye World", (Object)out.getMessage().getBody());
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testOnExceptionNotHandled() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.onException(Exception.class).handled(false).setBody((Expression)this.simple("Error: ${body}"));
                ((RouteDefinition)this.from("direct:receive").toD("direct:${header.where}", null, "bye")).to("mock:result");
                ((ProcessorDefinition)this.from("direct:foo").transform().simple("Bye ${body}")).throwException((Exception)new IllegalArgumentException("Forced"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        Exchange out = this.template.request("direct:receive", e -> {
            e.getMessage().setHeader("where", (Object)"foo");
            e.getMessage().setBody((Object)"World");
        });
        Assertions.assertTrue((boolean)out.isFailed());
        Assertions.assertFalse((boolean)out.hasVariables());
        Assertions.assertEquals((Object)"Error: Bye World", (Object)out.getMessage().getBody());
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testDeadLetterChannel() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:dead"));
                ((RouteDefinition)this.from("direct:receive").toD("direct:${header.where}", null, "bye")).to("mock:result");
                ((ProcessorDefinition)this.from("direct:foo").transform().simple("Bye ${body}")).throwException((Exception)new IllegalArgumentException("Forced"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:dead").expectedMessageCount(1);
        Exchange out = this.template.request("direct:receive", e -> {
            e.getMessage().setHeader("where", (Object)"foo");
            e.getMessage().setBody((Object)"World");
        });
        Assertions.assertFalse((boolean)out.isFailed());
        Assertions.assertFalse((boolean)out.hasVariables());
        Assertions.assertEquals((Object)"Bye World", (Object)out.getMessage().getBody());
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testDefaultErrorHandler() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.defaultErrorHandler());
                ((RouteDefinition)this.from("direct:receive").toD("direct:${header.where}", null, "bye")).to("mock:result");
                ((ProcessorDefinition)this.from("direct:foo").transform().simple("Bye ${body}")).throwException((Exception)new IllegalArgumentException("Forced"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        Exchange out = this.template.request("direct:receive", e -> {
            e.getMessage().setHeader("where", (Object)"foo");
            e.getMessage().setBody((Object)"World");
        });
        Assertions.assertTrue((boolean)out.isFailed());
        Assertions.assertFalse((boolean)out.hasVariables());
        Assertions.assertEquals((Object)"Bye World", (Object)out.getMessage().getBody());
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testStop() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:receive").toD("direct:${header.where}", null, "bye")).to("mock:result");
                ((ProcessorDefinition)this.from("direct:foo").transform().simple("Bye ${body}")).stop();
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        Exchange out = this.template.request("direct:receive", e -> {
            e.getMessage().setHeader("where", (Object)"foo");
            e.getMessage().setBody((Object)"World");
        });
        Assertions.assertFalse((boolean)out.isFailed());
        Assertions.assertFalse((boolean)out.hasVariables());
        Assertions.assertEquals((Object)"Bye World", (Object)out.getMessage().getBody());
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testRollback() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:receive").toD("direct:${header.where}", null, "bye")).to("mock:result");
                ((ProcessorDefinition)this.from("direct:foo").transform().simple("Bye ${body}")).rollback();
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        Exchange out = this.template.request("direct:receive", e -> {
            e.getMessage().setHeader("where", (Object)"foo");
            e.getMessage().setBody((Object)"World");
        });
        Assertions.assertTrue((boolean)out.isFailed());
        Assertions.assertFalse((boolean)out.hasVariables());
        Assertions.assertEquals((Object)"Bye World", (Object)out.getMessage().getBody());
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testMarkRollbackLast() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:receive").toD("direct:${header.where}", null, "bye")).to("mock:result");
                ((ProcessorDefinition)this.from("direct:foo").transform().simple("Bye ${body}")).markRollbackOnly();
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        Exchange out = this.template.request("direct:receive", e -> {
            e.getMessage().setHeader("where", (Object)"foo");
            e.getMessage().setBody((Object)"World");
        });
        Assertions.assertFalse((boolean)out.isFailed());
        Assertions.assertFalse((boolean)out.hasVariables());
        Assertions.assertEquals((Object)"Bye World", (Object)out.getMessage().getBody());
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testMarkRollbackOnlyLast() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:receive").toD("direct:${header.where}", null, "bye")).to("mock:result");
                ((ProcessorDefinition)this.from("direct:foo").transform().simple("Bye ${body}")).markRollbackOnlyLast();
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        Exchange out = this.template.request("direct:receive", e -> {
            e.getMessage().setHeader("where", (Object)"foo");
            e.getMessage().setBody((Object)"World");
        });
        Assertions.assertFalse((boolean)out.isFailed());
        Assertions.assertFalse((boolean)out.hasVariables());
        Assertions.assertEquals((Object)"Bye World", (Object)out.getMessage().getBody());
        this.assertMockEndpointsSatisfied();
    }
}

