/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ToDynamicTest
extends ContextTestSupport {
    @Test
    public void testToDynamic() throws Exception {
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello Camel"});
        this.getMockEndpoint("mock:bar").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello Camel", "foo", (Object)"foo");
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"bar");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testToDynamicInvalid() {
        try {
            this.template.sendBody("direct:start", (Object)"Hello Camel");
            Assertions.fail((String)"Should fail");
        }
        catch (CamelExecutionException e) {
            ToDynamicTest.assertIsInstanceOf(ResolveEndpointFailedException.class, e.getCause());
        }
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").toD("mock:${header.foo}");
            }
        };
    }
}

