/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.List;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockComponent;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.SendDynamicProcessor;
import org.apache.camel.support.DefaultProducer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ToDynamicStopProducerTest
extends ContextTestSupport {
    private static String events = "";

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testNoCache() throws Exception {
        events = "";
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ToDynamicStopProducerTest.this.context.addComponent("mymock", (Component)new MyMockComponent());
                ((RouteDefinition)this.from("direct:a").toD("${header.myHeader}", -1)).id("foo");
            }
        });
        this.context.start();
        Assertions.assertEquals((int)1, (int)this.context.getEndpointRegistry().size());
        this.sendBody("foo", "mymock:x");
        this.sendBody("foo", "mymock:y");
        this.sendBody("foo", "mymock:z");
        this.sendBody("bar", "mymock:x");
        this.sendBody("bar", "mymock:y");
        this.sendBody("bar", "mymock:z");
        List<Processor> list = this.getProcessors("foo");
        SendDynamicProcessor sdp = (SendDynamicProcessor)list.get(0);
        Assertions.assertNotNull((Object)sdp);
        Assertions.assertEquals((int)-1, (int)sdp.getCacheSize());
        Assertions.assertEquals((int)1, (int)this.context.getEndpointRegistry().size());
        Assertions.assertEquals((Object)"xyzxyz", (Object)events);
        this.context.stop();
        Assertions.assertEquals((Object)"xyzxyz", (Object)events);
    }

    @Test
    public void testDefaultCache() throws Exception {
        events = "";
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ToDynamicStopProducerTest.this.context.addComponent("mymock", (Component)new MyMockComponent());
                ((RouteDefinition)this.from("direct:a").toD("${header.myHeader}")).id("foo");
            }
        });
        this.context.start();
        Assertions.assertEquals((int)1, (int)this.context.getEndpointRegistry().size());
        this.sendBody("foo", "mymock:x");
        this.sendBody("foo", "mymock:y");
        this.sendBody("foo", "mymock:z");
        this.sendBody("bar", "mymock:x");
        this.sendBody("bar", "mymock:y");
        this.sendBody("bar", "mymock:z");
        List<Processor> list = this.getProcessors("foo");
        SendDynamicProcessor sdp = (SendDynamicProcessor)list.get(0);
        Assertions.assertNotNull((Object)sdp);
        Assertions.assertEquals((int)0, (int)sdp.getCacheSize());
        Assertions.assertEquals((int)4, (int)this.context.getEndpointRegistry().size());
        Assertions.assertEquals((Object)"", (Object)events);
        this.context.stop();
        Assertions.assertEquals((Object)"xyz", (Object)events);
    }

    @Test
    public void testCacheOne() throws Exception {
        events = "";
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ToDynamicStopProducerTest.this.context.addComponent("mymock", (Component)new MyMockComponent());
                ((RouteDefinition)this.from("direct:a").toD("${header.myHeader}", 1)).id("foo");
            }
        });
        this.context.start();
        Assertions.assertEquals((int)1, (int)this.context.getEndpointRegistry().size());
        this.sendBody("foo", "mymock:x");
        this.sendBody("foo", "mymock:y");
        this.sendBody("foo", "mymock:z");
        this.sendBody("bar", "mymock:x");
        this.sendBody("bar", "mymock:y");
        this.sendBody("bar", "mymock:z");
        List<Processor> list = this.getProcessors("foo");
        SendDynamicProcessor sdp = (SendDynamicProcessor)list.get(0);
        Assertions.assertNotNull((Object)sdp);
        Assertions.assertEquals((int)1, (int)sdp.getCacheSize());
        Assertions.assertEquals((int)2, (int)this.context.getEndpointRegistry().size());
        Assertions.assertEquals((Object)"xyzxy", (Object)events);
        this.context.stop();
        Assertions.assertEquals((Object)"xyzxyz", (Object)events);
    }

    @Test
    public void testCacheTwo() throws Exception {
        events = "";
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ToDynamicStopProducerTest.this.context.addComponent("mymock", (Component)new MyMockComponent());
                ((RouteDefinition)this.from("direct:a").toD("${header.myHeader}", 2)).id("foo");
            }
        });
        this.context.start();
        Assertions.assertEquals((int)1, (int)this.context.getEndpointRegistry().size());
        this.sendBody("foo", "mymock:x");
        this.sendBody("foo", "mymock:y");
        this.sendBody("foo", "mymock:z");
        this.sendBody("bar", "mymock:x");
        this.sendBody("bar", "mymock:y");
        this.sendBody("bar", "mymock:z");
        List<Processor> list = this.getProcessors("foo");
        SendDynamicProcessor sdp = (SendDynamicProcessor)list.get(0);
        Assertions.assertNotNull((Object)sdp);
        Assertions.assertEquals((int)2, (int)sdp.getCacheSize());
        Assertions.assertEquals((int)3, (int)this.context.getEndpointRegistry().size());
        Assertions.assertEquals((Object)"xyzx", (Object)events);
        this.context.stop();
        Assertions.assertEquals((Object)"xyzxyz", (Object)events);
    }

    @Test
    public void testCacheThree() throws Exception {
        events = "";
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ToDynamicStopProducerTest.this.context.addComponent("mymock", (Component)new MyMockComponent());
                ((RouteDefinition)this.from("direct:a").toD("${header.myHeader}", 3)).id("foo");
            }
        });
        this.context.start();
        Assertions.assertEquals((int)1, (int)this.context.getEndpointRegistry().size());
        this.sendBody("foo", "mymock:x");
        this.sendBody("foo", "mymock:y");
        this.sendBody("foo", "mymock:z");
        this.sendBody("bar", "mymock:x");
        this.sendBody("bar", "mymock:y");
        this.sendBody("bar", "mymock:z");
        List<Processor> list = this.getProcessors("foo");
        SendDynamicProcessor sdp = (SendDynamicProcessor)list.get(0);
        Assertions.assertNotNull((Object)sdp);
        Assertions.assertEquals((int)3, (int)sdp.getCacheSize());
        Assertions.assertEquals((int)4, (int)this.context.getEndpointRegistry().size());
        Assertions.assertEquals((Object)"", (Object)events);
        this.context.stop();
        Assertions.assertEquals((Object)"xyz", (Object)events);
    }

    protected void sendBody(String body, String uri) {
        this.template.sendBodyAndHeader("direct:a", (Object)body, "myHeader", (Object)uri);
    }

    private class MyMockProducer
    extends DefaultProducer {
        public MyMockProducer(MyMockEndpoint endpoint) {
            super((Endpoint)endpoint);
        }

        public MyMockEndpoint getEndpoint() {
            return (MyMockEndpoint)super.getEndpoint();
        }

        public void process(Exchange exchange) {
        }

        protected void doStop() throws Exception {
            super.doStop();
            events = events + this.getEndpoint().getQueue();
        }
    }

    private class MyMockEndpoint
    extends MockEndpoint {
        private final String queue;

        public MyMockEndpoint(MyMockComponent component, String uri, String queue) {
            super(uri, (Component)component);
            this.queue = queue;
        }

        public String getQueue() {
            return this.queue;
        }

        public Producer createProducer() {
            return new MyMockProducer(this);
        }
    }

    private class MyMockComponent
    extends MockComponent {
        private MyMockComponent() {
        }

        protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) {
            return new MyMockEndpoint(this, uri, remaining);
        }
    }
}

