/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.bar.BarComponent;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.support.component.EndpointUriFactorySupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ToDynamicSendDynamicAwareTest
extends ContextTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getRegistry().bind("myFactory", (Object)new BarEndpointUriFactory());
        return context;
    }

    @Test
    public void testToDynamic() throws Exception {
        this.getMockEndpoint("mock:bar").expectedBodiesReceived(new Object[]{"Hello Camel ordered beer", "Hello World ordered wine"});
        ((MockValueBuilder)this.getMockEndpoint("mock:bar").allMessages().header("CamelBarDrink")).isNull();
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello Camel", "drink", (Object)"beer");
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "drink", (Object)"wine");
        this.assertMockEndpointsSatisfied();
        boolean found = this.context.getEndpointRegistry().containsKey((Object)"bar://order");
        Assertions.assertTrue((boolean)found, (String)"There should only be one bar endpoint");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ToDynamicSendDynamicAwareTest.this.context.addComponent("bar", (Component)new BarComponent());
                ((RouteDefinition)this.from("direct:start").toD("bar:order?drink=${header.drink}")).to("mock:bar");
            }
        };
    }

    private static class BarEndpointUriFactory
    extends EndpointUriFactorySupport {
        private BarEndpointUriFactory() {
        }

        public boolean isEnabled(String scheme) {
            return "bar".equals(scheme);
        }

        public String buildUri(String scheme, Map<String, Object> properties, boolean encode) {
            return null;
        }

        public Set<String> propertyNames() {
            HashSet<String> answer = new HashSet<String>();
            answer.add("name");
            answer.add("drink");
            return answer;
        }

        public Set<String> secretPropertyNames() {
            return null;
        }

        public Set<String> multiValuePrefixes() {
            return null;
        }

        public boolean isLenientProperties() {
            return false;
        }
    }
}

