/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ToDynamicPropertyPlaceholderTest
extends ContextTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        Properties prop = new Properties();
        prop.setProperty("foo", "${header.myHeader}");
        context.getPropertiesComponent().setInitialProperties(prop);
        return context;
    }

    @Test
    public void testToDynamic() throws Exception {
        this.getMockEndpoint("mock:cheese").expectedBodiesReceived(new Object[]{"Hello Camel"});
        this.getMockEndpoint("mock:cake").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello Camel", "myHeader", (Object)"cheese");
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "myHeader", (Object)"cake");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testToDynamicNoHeader() {
        try {
            this.template.sendBody("direct:start", (Object)"Hello Camel");
            Assertions.fail((String)"Should throw exception");
        }
        catch (Exception e) {
            ResolveEndpointFailedException ref = ToDynamicPropertyPlaceholderTest.assertIsInstanceOf(ResolveEndpointFailedException.class, e.getCause());
            Assertions.assertEquals((Object)"mock:", (Object)ref.getUri());
        }
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").toD("mock:{{foo}}");
            }
        };
    }
}

