/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockComponent;
import org.apache.camel.model.ToDynamicDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ToDynamicAutoStartupComponentsTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testAutoStartupFalse() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ToDynamicDefinition toD = new ToDynamicDefinition("mock:${header.foo}");
                toD.setAutoStartComponents("false");
                this.from("direct:start").getOutputs().add(toD);
            }
        });
        this.context.start();
        Assertions.assertNull((Object)this.context.hasComponent("mock"));
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello Camel"});
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello Camel", "foo", (Object)"foo");
        this.assertMockEndpointsSatisfied();
        MockComponent comp = (MockComponent)this.context.hasComponent("mock");
        Assertions.assertNotNull((Object)comp);
        Assertions.assertTrue((boolean)comp.getStatus().isStarted());
    }

    @Test
    public void testAutoStartupTrue() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ToDynamicDefinition toD = new ToDynamicDefinition("mock:${header.foo}");
                toD.setAutoStartComponents("true");
                this.from("direct:start").getOutputs().add(toD);
            }
        });
        this.context.start();
        MockComponent comp = (MockComponent)this.context.hasComponent("mock");
        Assertions.assertNotNull((Object)comp);
        Assertions.assertTrue((boolean)comp.getStatus().isStarted());
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello Camel"});
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello Camel", "foo", (Object)"foo");
        this.assertMockEndpointsSatisfied();
    }
}

