/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ThrowExceptionMessageTest
extends ContextTestSupport {
    @Test
    public void testThrowExceptionMessage() throws Exception {
        this.getMockEndpoint("mock:start").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            Assertions.fail((String)"Should have thrown an exception");
        }
        catch (CamelExecutionException e) {
            ThrowExceptionMessageTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            Assertions.assertEquals((Object)"Darn Hello World is invalid", (Object)e.getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").to("mock:start")).throwException(IllegalArgumentException.class, "Darn ${body} is invalid")).to("mock:result");
            }
        };
    }
}

