/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ThreadsZeroInCoreAndMaxPoolTest
extends ContextTestSupport {
    public void xtestThreadsCoreAndMaxPool() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testThreadsCoreBeZero() {
        try {
            this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() {
                    this.from("direct:start").threads(-1, 2).to("mock:result");
                }
            });
            Assertions.fail((String)"Expect FailedToCreateRouteException exception here");
        }
        catch (Exception ex) {
            boolean b = ex.getCause() instanceof IllegalArgumentException;
            Assertions.assertTrue((boolean)b);
        }
    }

    @Test
    public void testThreadsCoreAndMaxPoolBuilder() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:foo").threads().maxPoolSize(20).threadName("myPool").to("mock:result");
            }
        };
    }
}

