/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.ThreadsDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ThreadsRequestReplyTest
extends ContextTestSupport {
    private static String beforeThreadName;
    private static String afterThreadName;

    @Test
    public void testThreadsInOut() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        String reply = (String)this.template.requestBody("direct:start", (Object)"Hello World", String.class);
        Assertions.assertEquals((Object)"Bye World", (Object)reply);
        this.assertMockEndpointsSatisfied();
        Assertions.assertFalse((boolean)beforeThreadName.equalsIgnoreCase(afterThreadName), (String)"Should use different threads");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ThreadsRequestReplyTest.this.context.setTracing(Boolean.valueOf(true));
                ((ThreadsDefinition)((ThreadsDefinition)((ThreadsDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").to("log:before")).process(new Processor(){

                    public void process(Exchange exchange) {
                        beforeThreadName = Thread.currentThread().getName();
                    }
                })).threads(5).process(new Processor(){

                    public void process(Exchange exchange) {
                        afterThreadName = Thread.currentThread().getName();
                    }
                })).to("log:after")).to("mock:result")).transform((Expression)this.constant("Bye World"));
            }
        };
    }
}

