/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.util.concurrent.ThreadPoolRejectedPolicy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ThreadsInvalidConfigTest
extends ContextTestSupport {
    final ThreadPoolProfile threadPoolProfile = new ThreadPoolProfile("poll");

    @Test
    public void testCreateRouteIfNoInvalidOptions() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ThreadsInvalidConfigTest.this.context.getExecutorServiceManager().registerThreadPoolProfile(ThreadsInvalidConfigTest.this.threadPoolProfile);
                this.from("direct:start").threads().executorService(ThreadsInvalidConfigTest.this.threadPoolProfile.getId()).to("mock:test");
            }
        });
    }

    @Test
    public void testFailIfThreadNameAndExecutorServiceRef() {
        try {
            this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() {
                    ThreadsInvalidConfigTest.this.context.getExecutorServiceManager().registerThreadPoolProfile(ThreadsInvalidConfigTest.this.threadPoolProfile);
                    this.from("direct:start").threads().executorService(ThreadsInvalidConfigTest.this.threadPoolProfile.getId()).threadName("foo").to("mock:test");
                }
            });
        }
        catch (Exception e) {
            boolean b = e.getCause() instanceof IllegalArgumentException;
            Assertions.assertTrue((boolean)b);
            Assertions.assertTrue((boolean)e.getCause().getMessage().startsWith("ThreadName"));
            return;
        }
        Assertions.fail();
    }

    @Test
    public void testPassIfThreadNameWithoutExecutorServiceRef() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ThreadsInvalidConfigTest.this.context.getExecutorServiceManager().registerThreadPoolProfile(ThreadsInvalidConfigTest.this.threadPoolProfile);
                this.from("direct:start").threads().threadName("foo").to("mock:test");
            }
        });
    }

    @Test
    public void testFailIfPoolSizeAndExecutorServiceRef() {
        try {
            this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() {
                    ThreadsInvalidConfigTest.this.context.getExecutorServiceManager().registerThreadPoolProfile(ThreadsInvalidConfigTest.this.threadPoolProfile);
                    this.from("direct:start").threads().executorService(ThreadsInvalidConfigTest.this.threadPoolProfile.getId()).poolSize(1).to("mock:test");
                }
            });
        }
        catch (Exception e) {
            boolean b = e.getCause() instanceof IllegalArgumentException;
            Assertions.assertTrue((boolean)b);
            Assertions.assertTrue((boolean)e.getCause().getMessage().startsWith("PoolSize"));
            return;
        }
        Assertions.fail();
    }

    @Test
    public void testFailIfMaxPoolSizeAndExecutorServiceRef() {
        try {
            this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() {
                    ThreadsInvalidConfigTest.this.context.getExecutorServiceManager().registerThreadPoolProfile(ThreadsInvalidConfigTest.this.threadPoolProfile);
                    this.from("direct:start").threads().executorService(ThreadsInvalidConfigTest.this.threadPoolProfile.getId()).maxPoolSize(1).to("mock:test");
                }
            });
        }
        catch (Exception e) {
            boolean b = e.getCause() instanceof IllegalArgumentException;
            Assertions.assertTrue((boolean)b);
            Assertions.assertTrue((boolean)e.getCause().getMessage().startsWith("MaxPoolSize"));
            return;
        }
        Assertions.fail();
    }

    @Test
    public void testFailIfKeepAliveTimeAndExecutorServiceRef() {
        try {
            this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() {
                    ThreadsInvalidConfigTest.this.context.getExecutorServiceManager().registerThreadPoolProfile(ThreadsInvalidConfigTest.this.threadPoolProfile);
                    this.from("direct:start").threads().executorService(ThreadsInvalidConfigTest.this.threadPoolProfile.getId()).keepAliveTime(1L).to("mock:test");
                }
            });
        }
        catch (Exception e) {
            boolean b = e.getCause() instanceof IllegalArgumentException;
            Assertions.assertTrue((boolean)b);
            Assertions.assertTrue((boolean)e.getCause().getMessage().startsWith("KeepAliveTime"));
            return;
        }
        Assertions.fail();
    }

    @Test
    public void testFailIfMaxQueueSizeAndExecutorServiceRef() {
        try {
            this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() {
                    ThreadsInvalidConfigTest.this.context.getExecutorServiceManager().registerThreadPoolProfile(ThreadsInvalidConfigTest.this.threadPoolProfile);
                    this.from("direct:start").threads().executorService(ThreadsInvalidConfigTest.this.threadPoolProfile.getId()).maxQueueSize(1).to("mock:test");
                }
            });
        }
        catch (Exception e) {
            boolean b = e.getCause() instanceof IllegalArgumentException;
            Assertions.assertTrue((boolean)b);
            Assertions.assertTrue((boolean)e.getCause().getMessage().startsWith("MaxQueueSize"));
            return;
        }
        Assertions.fail();
    }

    @Test
    public void testFailIfRejectedPolicyAndExecutorServiceRef() {
        try {
            this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() {
                    ThreadsInvalidConfigTest.this.context.getExecutorServiceManager().registerThreadPoolProfile(ThreadsInvalidConfigTest.this.threadPoolProfile);
                    this.from("direct:start").threads().executorService(ThreadsInvalidConfigTest.this.threadPoolProfile.getId()).rejectedPolicy(ThreadPoolRejectedPolicy.Abort).to("mock:test");
                }
            });
        }
        catch (Exception e) {
            boolean b = e.getCause() instanceof IllegalArgumentException;
            Assertions.assertTrue((boolean)b);
            Assertions.assertTrue((boolean)e.getCause().getMessage().startsWith("RejectedPolicy"));
            return;
        }
        Assertions.fail();
    }
}

